<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace SaveEvent;

use Pimcore\Model\Object\ArtikelFamilie;
use Pimcore\Model\Object\ProduktGruppe;

/**
 * Class PrioDescription
 *
 * @package SaveEvent
 */
class PrioDescription
{
    /**
     * handle
     *
     * @param ArtikelFamilie $object
     *
     * @return ArtikelFamilie
     */
    public function handle($object)
    {
        if ($object instanceof ArtikelFamilie) {
            // load linked Produktgruppen
            $produktGruppen = $object->getDisplayProduktgruppen();
            foreach ($produktGruppen as $produktGruppe) {
                $this->setPrioProductGroup($object, $produktGruppe)->save();
            }
        }
        return $object;
    }

    /**
     * setPrioProductGroup
     *
     * @param ArtikelFamilie $artikelFamilie
     * @param ProduktGruppe $produktGruppe
     * @return ProduktGruppe
     */
    public function setPrioProductGroup($artikelFamilie, $produktGruppe)
    {
        // get current prio state of Artikelfamilie
        $produktGruppe->setDisplayPrioLangtextStylefile($artikelFamilie->getDisplayPrioLangtextStylefile())
            ->setDisplayPrioLangtextBigtree($artikelFamilie->getDisplayPrioLangtextBigtree());

        return $produktGruppe;
    }

}
