<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Asset\RabbitMq\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use Lifestyle\Asset\RabbitMq\Distributor\PublishDistributor;
use Lifestyle\Asset\RabbitMq\Distributor\UnpublishDistributor;

/**
 * Class Configuration
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Asset\RabbitMq\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('lifestyle_asset_rabbit_mq');

        $rootNode
            ->children()
                ->arrayNode('publish_distributors')
                    ->useAttributeAsKey('name')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('class')->defaultValue(PublishDistributor::class)->end()
                            ->arrayNode('events')
                                ->scalarPrototype()->defaultValue([])->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('unpublish_distributors')
                    ->useAttributeAsKey('name')
                    ->arrayPrototype()
                        ->children()
                            ->scalarNode('class')->defaultValue(UnpublishDistributor::class)->end()
                            ->arrayNode('events')
                                ->scalarPrototype()->defaultValue([])->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
