<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Asset\RabbitMq\Distributor;

use Lifestyle\Asset\RabbitMq\Handler\HandlerInterface as AssetHandlerInterface;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\RabbitMq\Consumer\Handler\HandlerInterface;

/**
 * Class PublishDistributor
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Asset\RabbitMq\Distributor
 */
class PublishDistributor implements HandlerInterface
{
    /**
     * @var AssetHandlerInterface
     */
    private $assetHandler;

    /**
     * @var array
     */
    private $responsibleEvents = [];

    /**
     * PublishDistributor constructor.
     * @param AssetHandlerInterface $assetHandler
     * @param array $responsibleEvents
     */
    public function __construct(AssetHandlerInterface $assetHandler, array $responsibleEvents)
    {
        $this->assetHandler = $assetHandler;
        $this->responsibleEvents = $responsibleEvents;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool Should return true, if data has been processed
     */
    public function handle(DataCollectorInterface $dataCollector): bool
    {
        return
            $this->isResponsible($dataCollector) &&
            $this->assetHandler->publish($dataCollector);
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return bool
     */
    private function isResponsible(DataCollectorInterface $dataCollector): bool
    {
        return
            null !== ($eventName = $dataCollector->getItemValue('event')) &&
            in_array(strtolower($eventName), $this->responsibleEvents) &&
            $this->assetHandler->isResponsible($dataCollector);
    }
}
