# Asset RabbitMQ Bundle

This bundle provides a rabbit-mq consumer to process messages that contains assets from a rabbit-mq to local file system. 

Installation
============

Before you can install this bundle using composer, you have to update your ```composer.json```
manually because of some composer limitations using private repositories:

```json
{
    ...
    "repositories": [
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/asset-rabbitmq-bundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
        }
    ]
}
```

Install the package:
```bash
composer require lifestyle/asset-rabbitmq-bundle
```

After you have installed the package, you just need to add the bundle to your Kernel:

Symfony 3 ```app/AppKernel.php```:
```php
// in AppKernel::registerBundles()
$bundles = array(
    // ...
    new OldSound\RabbitMqBundle\OldSoundRabbitMqBundle(),
    new JMS\SerializerBundle\JMSSerializerBundle(),
    new Symfony\Bundle\MonologBundle\MonologBundle(),
    new Lifestyle\Asset\RabbitMq\LifestyleAssetRabbitMqBundle(),
    new Lifestyle\RabbitMq\Consumer\LifestyleRabbitMqConsumerBundle(),
    // ...
);
```

Symfony 4 ```config/bundles.php```:

This is done automatically, but you may check this:

```php
return [
    // ...
    OldSound\RabbitMqBundle\OldSoundRabbitMqBundle::class => ['all' => true],
    JMS\SerializerBundle\JMSSerializerBundle::class => ['all' => true],
    Symfony\Bundle\MonologBundle\MonologBundle::class => ['all' => true],
    Lifestyle\Asset\RabbitMq\LifestyleAssetRabbitMqBundle::class => ['all' => true],
    Lifestyle\RabbitMq\Consumer\LifestyleRabbitMqConsumerBundle::class => ['all' => true],
    // ...
];
```

Please refer to the other bundles documentation for further information.

Configuration
=============

LifestyleAssetRabbitMqBundle requires an initial configuration. Otherwise no distributor
will be registered, so any message will be rejected.

Extension Reference
-------------------

```yaml
lifestyle_asset_rabbit_mq:
    publish_distributors:
        assets:
            events: [ 'Asset.Image.publish', 'Asset.Document.publish' ]
    unpublish_distributors:
        assets:
            events: [ 'Asset.Image.unpublish', 'Asset.Document.unpublish' ]
```

Service Configuration
=====================

To connect your consumer to the ```oldsound/rabbitmq-bundle``` a service has to be configured in your projects ```services.yml```.
If execution should stop on errors set 3rd parameter to true. This might be helpful for debugging, but should never used in production.

If you have Apache running and you want to have beautiful asset-urls, use ```Lifestyle\Asset\RabbitMq\Handler\LocalFileHandler``` instead of ```Lifestyle\Asset\RabbitMq\Handler\DefaultFileHandler```

```yaml
services:
    // ...
    Lifestyle\Asset\RabbitMq\Handler\HandlerInterface:
        class: Lifestyle\Asset\RabbitMq\Handler\DefaultFileHandler
        arguments:
            - '%env(ASSETS_SOURCE_URL)%'
            - '%env(ASSETS_WEB_FOLDER)%'
            - '%env(ASSETS_TARGET_PATH)%'
            - '@logger'
```

You might also configure your ```oldsound/rabbitmq-bundle```:

```yaml
old_sound_rabbit_mq:
    connections:
        default:
            url: 'amqp://guest:guest_pw@localhost:5672?vhost=internal'
    consumers:
        product_data:
            connection: default
            callback: Lifestyle\RabbitMq\Consumer\Consumer\Consumer
            queue_options: { name: 'pimcore-to-asset' }
            enable_logger: true
            auto_setup_fabric: false
```

Set environment variables or use the ```.env.local```:

```
ASSETS_SOURCE_URL=http://pimcore.loc
ASSETS_WEB_FOLDER=/path/to/target/folder/web
ASSETS_TARGET_PATH=/assets
```

Usage
=====

```bash
php bin/console rabbitmq:consumer asset_data
```
