<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Asset\RabbitMq\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Lifestyle\Asset\RabbitMq\Handler\HandlerInterface;
use Lifestyle\RabbitMq\Producer\Producer\ProducerInterface;

/**
 * Class LifestyleAssetRabbitMqExtension
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Asset\RabbitMq\DependencyInjection
 */
class LifestyleAssetRabbitMqExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $processedConfiguration = $this->processConfiguration($configuration, $configs);

        $this->createDistributors(
            'lifestyle_asset_rabbitmq.publish_distributor',
            $processedConfiguration['publish_distributors'],
            $container
        );
        $this->createDistributors(
            'lifestyle_asset_rabbitmq.unpublish_distributor',
            $processedConfiguration['unpublish_distributors'],
            $container
        );
    }

    /**
     * @param string $servicePrefix
     * @param array $distributors
     * @param ContainerBuilder $container
     */
    private function createDistributors($servicePrefix, array $distributors, ContainerBuilder $container)
    {
        foreach ($distributors as $distributor => $config) {
            $definition = new Definition($config['class'], [
                array_map('strtolower', $config['events']),
                new Reference(HandlerInterface::class),
                $config['forward_messages'] ? new Reference(ProducerInterface::class) : null,
            ]);
            $definition->addTag('lifestyle.rabbit_mq.consumer');
            $container->setDefinition($servicePrefix . '.' . strtolower($distributor), $definition);
        }
    }
}
