# Asset RabbitMQ Bundle

This bundle provides a rabbit-mq consumer to process messages that contains assets from a rabbit-mq to local file system. 

It also offers the possibility to forward the message to other consumers after successful processing (search for _forward_messages_).

Installation
============

Before you can install this bundle using composer, you have to update your ```composer.json```
manually because of some composer limitations using private repositories:

```json
{
    ...
    "repositories": [
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/asset-rabbitmq-bundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
        },
        {
            "type": "git",
            "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
        }
    ]
}
```

Install the package:
```bash
composer require lifestyle/asset-rabbitmq-bundle
```

After you have installed the package, you just need to add the bundle to your Kernel:

Symfony 3 ```app/AppKernel.php```:
```php
// in AppKernel::registerBundles()
$bundles = array(
    // ...
    new OldSound\RabbitMqBundle\OldSoundRabbitMqBundle(),
    new JMS\SerializerBundle\JMSSerializerBundle(),
    new Symfony\Bundle\MonologBundle\MonologBundle(),
    new Lifestyle\Asset\RabbitMq\LifestyleAssetRabbitMqBundle(),
    new Lifestyle\RabbitMq\Consumer\LifestyleRabbitMqConsumerBundle(),
    // ...
);
```

Symfony 4 ```config/bundles.php```:

This is done automatically, but you may check this:

```php
return [
    // ...
    OldSound\RabbitMqBundle\OldSoundRabbitMqBundle::class => ['all' => true],
    JMS\SerializerBundle\JMSSerializerBundle::class => ['all' => true],
    Symfony\Bundle\MonologBundle\MonologBundle::class => ['all' => true],
    Lifestyle\Asset\RabbitMq\LifestyleAssetRabbitMqBundle::class => ['all' => true],
    Lifestyle\RabbitMq\Consumer\LifestyleRabbitMqConsumerBundle::class => ['all' => true],
    // ...
];
```

Please refer to the other bundles documentation for further information.

Configuration
=============

LifestyleAssetRabbitMqBundle requires an initial configuration. Otherwise no distributor
will be registered, so any message will be rejected.

Extension Reference
-------------------

```yaml
lifestyle_asset_rabbit_mq:
    publish_distributors:
        assets:
            events: [ 'Asset.Image.publish', 'Asset.Document.publish' ]
            forward_messages: false # Set to true if message should be forwarded to another consumer using the rabbitMQ
    unpublish_distributors:
        assets:
            events: [ 'Asset.Image.unpublish', 'Asset.Document.unpublish' ]
            forward_messages: false
```

Service Configuration
=====================

To connect your consumer to the ```oldsound/rabbitmq-bundle``` a service has to be configured in your projects ```services.yml```.
If execution should stop on errors set 3rd parameter to true. This might be helpful for debugging, but should never used in production.

If you have Apache running and you want to have beautiful asset-urls, use ```Lifestyle\Asset\RabbitMq\Handler\LocalFileHandler``` instead of ```Lifestyle\Asset\RabbitMq\Handler\DefaultFileHandler```

```yaml
services:
    // ...
    Lifestyle\Asset\RabbitMq\Handler\HandlerInterface:
        class: Lifestyle\Asset\RabbitMq\Handler\DefaultFileHandler
        arguments:
            - '%env(ASSETS_SOURCE_URL)%'
            - '%env(ASSETS_WEB_FOLDER)%'
            - '%env(ASSETS_TARGET_PATH)%'
            - '@logger'
```

You might also configure your ```oldsound/rabbitmq-bundle```. The _producer_-part is only necessary if messages should be forwarded to other consumers.

```yaml
old_sound_rabbit_mq:
    connections:
        default:
            url: 'amqp://guest:guest_pw@localhost:5672?vhost=internal'
    consumers:
        asset_data:
            connection: 'default'
            callback: Lifestyle\RabbitMq\Consumer\Consumer\Consumer
            queue_options: { name: 'asset-consumer' }
            enable_logger: '%kernel.debug%'
            auto_setup_fabric: false
    producers:
        asset_data:
            connection: 'default'
            auto_setup_fabric: false
            exchange_options: { name: 'asset-forward-producer', type: 'THIS_HAS_NO_EFFECT_IF_NO_AUTO_SETUP_FABRIC' }
            enable_logger: '%kernel.debug%'
```

Set environment variables or use the ```.env.local```:

```
ASSETS_SOURCE_URL=http://pimcore.loc
ASSETS_WEB_FOLDER=/path/to/target/folder/web
ASSETS_TARGET_PATH=/assets
```

Usage
=====

```bash
php bin/console rabbitmq:consumer asset_data
```
