<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Asset\RabbitMq\Handler;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface HandlerInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Asset\RabbitMq\Handler
 */
interface HandlerInterface
{
    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector): bool;

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function publish(DataCollectorInterface $collector): bool;

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function delete(DataCollectorInterface $collector): bool;
}
