# computop-paygate-adapter

This library can be used to create the data required to use the computop paygate form.

## Installation

```bash
composer require lifestyle/computop-paygate-adapter
```

> Note: Make sure to add the lifestyle package repository to the `composer.json` file of the project like this:
> ```json
> {
>   // ...
>   "repositories": [
>     {
>       "type": "composer",
>       "url": "https://composer.life-style.de/"
>     }
>   ],
>   // ...
> }
> ```

> Note: While development, use the following configuration to work on this library and the project simultaneously:
> ```json
> {
>   // ...
>   "repositories": [
>     {
>       "type": "git",
>       "url": "./../computop-paygate-adapter"
>     }
>   ],
>   // ...
> }
> ```

## Usage

See `example.php` for a usage example usage scenario.

## Documentation

### Paytype documentation and field information

The definition for the short-name field description can be found here:

https://developer.computop.com/display/public/DOCCT/Definition+EN

* DirectDebit

  https://developer.computop.com/display/public/DOCCT/Direct+debit+EN#DirectdebitEN-Generalparametersoftheinterface

* CreditCard

  https://developer.computop.com/display/public/DOCCT/Card+processing+EN#CardprocessingEN-Generalparametersoftheinterface

* Klarna Sofort

  https://developer.computop.com/display/public/DOCCT/Klarna+Sofort+EN#KlarnaSofortEN-Callingtheinterface

* *To be continued...*

### Paytype handler

A paytype handler must implement `LifeStyle\ComputopPaygateAdapter\Paytype\PaytypeHandlerInterface` or extend
`LifeStyle\ComputopPaygateAdapter\Paytype\PaytypeHandlerAbstract` depending on the use-case. A rule of thumb is to use
the interface only if the bahviour of the paytype handler should differ from the default process defined inside of the
abstract class.

In any case, to use the newly created paytype handler, add it to the `LifeStyle\ComputopPaygateAdapter\PaygateService`
instance. Internally a slightly modified version of the
[strategy pattern](https://designpatternsphp.readthedocs.io/en/latest/Behavioral/Strategy/README.html) is used.

Here is an example of a basic paytype handler extending the abstract class:

```php
<?php

namespace LifeStyle\ComputopPaygateAdapter\Paytype;

class CustomPaytypeHandler extends PaytypeHandlerAbstract
{
    const PAYTYPE_NAME = '<paytype-identifier>';

    protected static $TARGET = 'https://www.computop-paygate.com/<paytype-target>.aspx';
}

```

The second step is to create a dedicated class for the paytype of `LifeStyle\ComputopPaygateAdapter\Model\RequestModel`
which holds all information and fields required/available.

Make sure to add the correct mapping for each field by setting additional fields inside the `getParameterData()` method
of that model.

### Paytype error-code testing

While the merchant account is in test-mode, the paygate can be manipulated to return a certain error code. Depending on
what paytype is used for testing, the model should contain a field called `orderDescription`.

It **must** be set to a value of `test:0000` to proceed with successful payments during testing. The part beyond the
colon can be substituted with any of the codes listed under *detailed error codes* found
[here](https://developer.computop.com/display/public/DOCCT/A4+Error+codes#A4Errorcodes-Digits5..8:Detailederrorcode).

## License

Proprietary.
