<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require './vendor/autoload.php';

use LifeStyle\ComputopPaygateAdapter\Model;
use LifeStyle\ComputopPaygateAdapter\Model\RequestModel;
use LifeStyle\ComputopPaygateAdapter\PaygateService;
use LifeStyle\ComputopPaygateAdapter\Paytype\CreditCardHandler;
use LifeStyle\ComputopPaygateAdapter\Paytype\DirectDebitHandler;
use LifeStyle\ComputopPaygateAdapter\Utility\ResponseFactory;
use LifeStyle\ComputopPaygateAdapter\Utility\Security;

Security::setKey('Rp5?d)K2Hr9_q]Y6');
Security::setKeyHash('9q)NH4y_z(2D5kP=?J8n3[fZ*pR76S!c');

$paygateService = new PaygateService();
$paytapeHandlerList = [
    new CreditCardHandler(),
    new DirectDebitHandler(),
];

foreach ($paytapeHandlerList as $paytypeHandler) {
    $paygateService->addPaytypeHandler($paytypeHandler);
}

/**
 * @return RequestModel
 */
function getRequestModel()
{
    $requestModel = new Model\CreditCard\RequestModel();
    // Pro-Tip: Look at the field documentation inside the model class.
    $requestModel
        ->setAmount(2000)
        ->setAmount3D(2000)
        ->setCurrency('EUR')
        ->setMerchantId('vtours_test')
        ->setTransactionId(124726274343)
        // Note: The redirect and notification target have to be "https"!
        ->setRedirectOnSuccess('https://localhost/example_success.php')
        ->setRedirectOnFailure('https://localhost/example_failure.php')
        ->setNotificationTarget('https://localhost/example_notify.php')
    ;

    return $requestModel;
}

$responseModel = $paygateService->create(CreditCardHandler::PAYTYPE_NAME, getRequestModel());
$responseModel->setPayloadData([
    'Language' => 'en',
    'URLBack' => 'https://localhost/example.php',
]);

$target = ResponseFactory::createTarget($responseModel);

echo '<pre>';
echo "<a href='{$target}' target='_blank'>{$target}</a>";
echo '</pre>';

return true;
