<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require './vendor/autoload.php';

use LifeStyle\ComputopPaygateAdapter\Utility\Security;

Security::setKey('Rp5?d)K2Hr9_q]Y6');
Security::setKeyHash('9q)NH4y_z(2D5kP=?J8n3[fZ*pR76S!c');

$_POST['Len'] = 537;
$_POST['Data'] = '69E3AC5316CB2A45ABA324C2B3BF3E79BEFC404B61CE9488F7C26027DADD9A45F2E7803CC8FD5006D9E05B5D412A45BF46BF7F903AACA173AC88732D742B0BA4DB2336CBE74E08BBFF559F9213784EE8735E361D98B71A50415434EBA9DCE728202D5E27338A8D334B3323A05EE2500AF3B307A8C121E51E6F53A1AB034D23B60048E8F898A6E7729481EB3B5C2AC3AE24EB9D455CAB702D81D478A7ED8A4D3B2AB43CA36B86A3E835940B23A06954DF0FEDBB6E190DC4250F2C97B1683940F3F85BCAD7C409FE85DA2246D035BFA39F2E2AC2111B39295DB7801C6DF927407D5E576A66467D05A6B3385BFFD83CC225E8A9016907D7D4744011C55D925731800075903DD765C878A3146FA0C626A810B0988F9EE7B60588461C7961ED5D8CF21B3AA29AC819D509526F9141DE45E34B50EF54B6626A189178FA58FF38C42597FF68EF37D7E5FEE108B96222DA98DCA8C9ADE3F7EF3B1FC9139D4FBF803EAB1D8C08546BDEB490C57A73B0F00311F42174F275184F8B1DB697977BE07364BA8231BDBF03C020B8E1C9D9D9CDA99D9F5103AAA3ADE1A18BBFAED977A22F8803620B36F1AA0B24AF38EDDEDD153F633621EDEA72D86FC70B62288818522BB4B2F876F1774B17A5DB96887FE16886522D9F876016E63A1D3217E52DDAEBF051581686B5524A9DDF37934E974FC484FF7F5BFE571F62FA6CA52FC049714982DFFECC450140B4CF51462ECBD1CD6AC670247951C3FD449756D01AC3A0F58658D119C2';

/**
 * Class Notification
 */
final class Notification
{
    /**
     * @var integer
     */
    private $length;

    /**
     * @var array
     */
    private $data;

    /**
     * Create a new notification instance from post-like array.
     *
     * @param array $parameterData
     * @return Notification
     */
    public static function createFromParameterData($parameterData)
    {
        $parameterData = array_replace([
            'Len' => 0,
            'Data' => '',
        ], $parameterData);

        $length = $parameterData['Len'];
        $data = $parameterData['Data'];

        return new self($length, $data);
    }

    /**
     * Notification constructor.
     * @param integer $length
     * @param string $data
     */
    private function __construct($length, $data)
    {
        $this->length = $length;
        $this->data = $data;
    }

    /**
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * @param int $length
     * @return Notification
     */
    public function setLength($length)
    {
        $this->length = $length;
        return $this;
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param string $data
     * @return Notification
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return array
     */
    public function getContent()
    {
        static $content;

        if (!$content) {
            $result = Security::decrypt($this->data);
            $result = substr($result, 0, $this->length);

            parse_str($result, $content);
        }

        return $content;
    }
}

$notification = Notification::createFromParameterData($_POST);
$notificationContent = $notification->getContent();

echo '<pre>';
var_dump($notificationContent);
echo '</pre>';

return true;
