<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Example;

use LifeStyle\ComputopPaygateAdapter\Utility\Security;

/**
 * Class Notification
 */
final class Notification
{
    /**
     * @var integer
     */
    private $length;

    /**
     * @var array
     */
    private $data;

    /**
     * Create a new notification instance from post-like array.
     *
     * @param array $parameterData
     * @return Notification
     */
    public static function createFromParameterData($parameterData)
    {
        $parameterData = array_replace([
            'Len' => 0,
            'Data' => '',
        ], $parameterData);

        $length = $parameterData['Len'];
        $data = $parameterData['Data'];

        return new self($length, $data);
    }

    /**
     * Notification constructor.
     * @param integer $length
     * @param string $data
     */
    private function __construct($length, $data)
    {
        $this->length = $length;
        $this->data = $data;
    }

    /**
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * @param int $length
     * @return Notification
     */
    public function setLength($length)
    {
        $this->length = $length;
        return $this;
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param string $data
     * @return Notification
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return array
     */
    public function getContent()
    {
        $result = Security::decrypt($this->data);
        $result = substr($result, 0, $this->length);

        parse_str($result, $content);

        return $content;
    }
}
