<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

// Initialize.
require_once __DIR__ . '/../../bootstrap.php';

use LifeStyle\ComputopPaygateAdapter\Example\Credential;
use LifeStyle\ComputopPaygateAdapter\Model;
use LifeStyle\ComputopPaygateAdapter\PaygateService;
use LifeStyle\ComputopPaygateAdapter\Paytype;
use LifeStyle\ComputopPaygateAdapter\Utility\ResponseFactory;

/**
 * @var string The template to use. Available known values are 'compatible' and 'responsive'.
 *              When set directly make sure to prefix with 'ct_'.
 *              New with 3DS 2.0: The '_ch' suffix template should be used to comply with regulations.
 */
$mode = 'compatible';

$paygateService = new PaygateService();
$paytypeHandlerList = [
    new Paytype\PaymentPage\CreditCardHandler(),
    new Paytype\PaymentPage\DirectDebitHandler(),
];

foreach ($paytypeHandlerList as $paytypeHandler) {
    $paygateService->addPaytypeHandler($paytypeHandler);
}

// Time of execution.
$time = time();
// Price in currency.
$price = 20.50;
// Currency of the price.
$priceCurrency = 'EUR';

$requestModel = (new Model\PaymentPage\CreditCard\GICC\RequestModel())
    ->setMerchantId(Credential::MERCHANT)
    ->setTransactionId("t{$time}")
    ->setAmount(100 * $price)
    ->setCurrency($priceCurrency)
    ->setRequestId("r{$time}")
    // Note: The redirect and notification target have to be "https"!
    ->setRedirectOnSuccess('https://localhost/example_success.php')
    ->setRedirectOnFailure('https://localhost/example_failure.php')
    ->setEncryptedResponse(true) // Optional
    ->setNotificationTarget('https://localhost/example_notify.php')
//    ->setUserData('json_encode($dataArray)') // Optional
//    ->setCustomData('weird=query|but=separated|by=pipe') // Optional
//    ->setAmount3D(100 * $price) // Conditional: Only 3D Secure
    ->setOrderDescription('test:0000')
;

// Response, the data that has to be sent to CompuTop.
$responseModel = $paygateService->create(Paytype\PaymentPage\CreditCardHandler::PAYTYPE_NAME, $requestModel);
// These have to be submitted without encryption, so they can be used by CompuTop .
$responseModel->setPayloadData([
    'Language' => 'en',
    'Template' => "ct_{$mode}", // With 3DS 2.0 use "ct_{$mode}_ch" instead.
    'URLBack' => 'https://localhost/example_notify.php',
]);

// Print the target and post body.
echo $responseModel->getTarget(), ' with ', print_r($responseModel->getParameterData(), true), PHP_EOL;

$target = ResponseFactory::createTarget($responseModel);
if ('cli' === PHP_SAPI) {
    echo 'Target at ', $target, PHP_EOL;
} else {
    echo '<pre>';
    echo "<a href='{$target}' target='_blank'>{$target}</a>";
    echo '</pre>';

    return true;
}
