<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard;

use LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\RequestModel as BaseRequestModel;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard
 */
class RequestModel extends BaseRequestModel
{
    /**
     * `Amount3D` -- Only for 3DSecure: Amount for authentication with Verified, SecureCode and SafeKey if Amount
     * deviates. Amount in the smallest currency unit (e.g. EUR Cent).
     *
     * @var int
     */
    private $amount3d;

    /**
     * `OrderDesc` -- Description of purchased goods, unit prices, ...
     *
     * To test error behaviour, set this to `test:0000`. The part beyond the colon can be substituted with any of the
     * codes listed under "Detailed error code".
     *
     * @var string
     */
    private $orderDescription;

    /**
     * @return int
     */
    public function getAmount3D()
    {
        return $this->amount3d;
    }

    /**
     * @param int $amount3d
     * @return RequestModel
     */
    public function setAmount3D($amount3d)
    {
        $this->amount3d = $amount3d;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDescription()
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestModel
     */
    public function setOrderDescription($orderDescription)
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();

        $parameterData['Amount3D'] = $this->amount3d;
        $parameterData['OrderDesc'] = $this->orderDescription;

        return $parameterData;
    }
}
