<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo;

use JsonSerializable;

/**
 * Class Consumer
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\Extra\ThreeDSecureTwo
 */
class Consumer implements JsonSerializable
{
    /**
     * `salutation` -- Salutation Values accepted:
     *
     * - `Mr`
     * - `Mrs`
     * - `Miss`
     *
     * @var string
     */
    private $salutation;

    /**
     * `firstName` -- Customers first name.
     *
     * @var string
     */
    private $firstName;

    /**
     * `lastname` -- Customer's last name.
     *
     * @var string
     */
    private $lastName;

    /**
     * `birthDate` -- Customer's birthdate in format `YYYY-MM-DD`.
     *
     * @var string
     */
    private $birthDate;

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     * @return Consumer
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return Consumer
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return Consumer
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return string
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }

    /**
     * @param string $birthDate
     * @return Consumer
     */
    public function setBirthDate($birthDate)
    {
        $this->birthDate = $birthDate;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'salutation' => $this->salutation,
            'firstName' => $this->firstName,
            'lastName' => $this->lastName,
            'birthDate' => $this->birthDate,
        ]);
    }
}
