<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CredentialOnFile;

use JsonSerializable;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CredentialOnFile\Type\Recurring;

/**
 * Class Type
 * @package LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CredentialOnFile
 */
class Type implements JsonSerializable
{
    /**
     * `recurring` -- Recurring payments are a series of transactions processed persuant
     * to an agreement between a cardholder and a merchant where the cardholder purchases
     * goods or services over a period of time through a number of separate transactions.
     * Please note that in the context of PSD2 and SCA requirements the European Banking
     * Authority (EBA) describes recurring payments as a series of transactions with the
     * same amount and with the same payee.
     *
     * @var Recurring
     */
    private $recurring;

    /**
     * `unscheduled` -- Value indicating the party that initiates a credential on file transaction that does not occur
     * on a fixed schedule. Values accepted:
     *
     * - `CIT` = Customer Initiated Transaction
     * - `MIT` = Merchant Initiated Transaction
     *
     * @var string
     */
    private $unscheduled;

    /**
     * @return Recurring
     */
    public function getRecurring()
    {
        return $this->recurring;
    }

    /**
     * @param Recurring $recurring
     * @return Type
     */
    public function setRecurring($recurring)
    {
        $this->recurring = $recurring;
        return $this;
    }

    /**
     * @return string
     */
    public function getUnscheduled()
    {
        return $this->unscheduled;
    }

    /**
     * @param string $unscheduled
     * @return Type
     */
    public function setUnscheduled($unscheduled)
    {
        $this->unscheduled = $unscheduled;
        return $this;
    }

    /**
     * @return mixed|void
     */
    public function jsonSerialize()
    {
        return array_filter([
            'recurring' => $this->recurring,
            'unscheduled' => $this->unscheduled,
        ]);
    }
}
