<?php
/*
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 *  @copyright 2020 Lifestyle Webconsulting GmbH
 *  @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CredentialOnFile\Type;


use JsonSerializable;

class Recurring implements JsonSerializable
{

    /**
     * `recurringFrequency` -- Indicates the number of days between authorisations.
     * @var int
     */
    private $recurringFrequency;

    /**
     * `recurringStartDate` -- Determines the date of the first authorization according to the recurring mandate. (Y-m-d)
     * @var string
     */
    private $recurringStartDate;

    /**
     * `recurringExpiryDate` -- Date after which no further authorisations shall be performed. (Y-m-d)
     * @var string
     */
    private $recurringExpiryDate;

    /**
     * @return int
     */
    public function getRecurringFrequency()
    {
        return $this->recurringFrequency;
    }

    /**
     * @param int $recurringFrequency
     * @return Recurring
     */
    public function setRecurringFrequency($recurringFrequency)
    {
        $this->recurringFrequency = $recurringFrequency;
        return $this;
    }

    /**
     * @return string
     */
    public function getRecurringStartDate()
    {
        return $this->recurringStartDate;
    }

    /**
     * @param string $recurringStartDate
     * @return Recurring
     */
    public function setRecurringStartDate($recurringStartDate)
    {
        $this->recurringStartDate = $recurringStartDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getRecurringExpiryDate()
    {
        return $this->recurringExpiryDate;
    }

    /**
     * @param string $recurringExpiryDate
     * @return Recurring
     */
    public function setRecurringExpiryDate($recurringExpiryDate)
    {
        $this->recurringExpiryDate = $recurringExpiryDate;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'recurringFrequency' => $this->recurringFrequency,
            'recurringStartDate' => $this->recurringStartDate,
            'recurringExpiryDate' => $this->recurringExpiryDate,
        ]);
    }
}