<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo;

use JsonSerializable;

/**
 * Class Business
 * @package LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo
 */
class Business implements JsonSerializable
{
    /**
     * `legalName` -- Business legal name.
     *
     * @var string
     */
    private $legalName;

    /**
     * `dbaName` -- Doing Business As.
     *
     * @var string
     */
    private $dbaName;

    /**
     * `registrationNumber` -- Business registration number.
     *
     * @var string
     */
    private $registrationNumber;

    /**
     * @return string
     */
    public function getLegalName()
    {
        return $this->legalName;
    }

    /**
     * @param string $legalName
     * @return Business
     */
    public function setLegalName($legalName)
    {
        $this->legalName = $legalName;
        return $this;
    }

    /**
     * @return string
     */
    public function getDbaName()
    {
        return $this->dbaName;
    }

    /**
     * @param string $dbaName
     * @return Business
     */
    public function setDbaName($dbaName)
    {
        $this->dbaName = $dbaName;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegistrationNumber()
    {
        return $this->registrationNumber;
    }

    /**
     * @param string $registrationNumber
     * @return Business
     */
    public function setRegistrationNumber($registrationNumber)
    {
        $this->registrationNumber = $registrationNumber;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'legalName' => $this->legalName,
            'dbaName' => $this->dbaName,
            'registrationNumber' => $this->registrationNumber,
        ]);
    }
}
