<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Example;

use LifeStyle\ComputopPaygateAdapter\Utility\Security;

/**
 * Class Credential
 */
final class Credential
{
    const MERCHANT = 'vtours_test';
    const MERCHANT_KEY = 'Rp5?d)K2Hr9_q]Y6';
    const MERCHANT_KEY_HASH = '9q)NH4y_z(2D5kP=?J8n3[fZ*pR76S!c';

    /**
     * Set up security.
     */
    public static function setup()
    {
        Security::setKey(static::MERCHANT_KEY);
        Security::setKeyHash(static::MERCHANT_KEY_HASH);
    }
}
