<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo;

use JsonSerializable;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\Address\AddressLine;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\Address\Country;

/**
 * Class BillingAddress
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\Extra\ThreeDSecureTwo
 */
class Address implements JsonSerializable
{
    /**
     * `city` -- City. Required unless market or regional mandate restricts sending this information. For shipping
     * details this data element might not be available (e.g. digital goods).
     *
     * @var string
     */
    private $city;

    /**
     * `country` -- Alpha-3 country code according to ISO 3166-1:2013. Required unless market or regional mandate
     * restricts sending this information. For shipping details this data element might not be available (e.g. digital
     * goods).
     *
     * @var Country
     */
    private $country;

    /**
     * `addressLine1` -- First line of the street address. Required unless market or regional mandate restricts sending
     * this information. For shipping details this data element might not be available (e.g. digital goods).
     *
     * @var AddressLine
     */
    private $addressLine1;

    /**
     * `addressLine2` -- Second line of the street address (e.g. apartment, suite, floor, PO Box, etc.). Required unless
     * market or regional mandate restricts sending this information. For shipping details this data element might not
     * be available (e.g. digital goods).
     *
     * @var string
     */
    private $addressLine2;

    /**
     * `addressLine3` -- Third line of the street address. Required unless market or regional mandate restricts sending
     * this information. For shipping details this data element might not be available (e.g. digital goods).
     *
     * @var string
     */
    private $addressLine3;

    /**
     * `postalCode` -- ZIP or other postal code. Required unless market or regional mandate restricts sending this
     * information. For shipping details this data element might not be available (e.g. digital goods).
     *
     * @var string
     */
    private $postalCode;

    /**
     * `state` -- Alpha-2 code of state or province according to ISO 3166-2. Required unless market or regional mandate
     * restricts sending this information, or State is not applicable for this country. For shipping details this data
     * element might not be available (e.g. digital goods).
     *
     * @var string
     */
    private $state;

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return Address
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return Country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param Country $country
     * @return Address
     */
    public function setCountry($country)
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return AddressLine
     */
    public function getAddressLine1()
    {
        return $this->addressLine1;
    }

    /**
     * @param AddressLine $addressLine1
     * @return Address
     */
    public function setAddressLine1($addressLine1)
    {
        $this->addressLine1 = $addressLine1;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
        return $this->addressLine2;
    }

    /**
     * @param string $addressLine2
     * @return Address
     */
    public function setAddressLine2($addressLine2)
    {
        $this->addressLine2 = $addressLine2;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine3()
    {
        return $this->addressLine3;
    }

    /**
     * @param string $addressLine3
     * @return Address
     */
    public function setAddressLine3($addressLine3)
    {
        $this->addressLine3 = $addressLine3;
        return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }

    /**
     * @param string $postalCode
     * @return Address
     */
    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @param string $state
     * @return Address
     */
    public function setState($state)
    {
        $this->state = $state;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'city' => $this->city,
            'country' => $this->country,
            'addressLine1' => $this->addressLine1,
            'addressLine2' => $this->addressLine2,
            'addressLine3' => $this->addressLine3,
            'postalCode' => $this->postalCode,
        ]);
    }
}
