<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo;

use JsonSerializable;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo\Business;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo\Consumer;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo\Phone;

/**
 * Class CustomerInfo
 * @package LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo
 */
class CustomerInfo implements JsonSerializable
{
    /**
     * `consumer` -- Object describing private customers. Required if the customer is a person.
     *
     * @var Consumer
     */
    private $consumer;

    /**
     * `business` -- Object describing business customers. Required if the customer is a legal entity.
     *
     * @var Business
     */
    private $business;

    /**
     * `phone` -- Phone number. Required (if available), unless market or regional mandate restricts sending this
     * information.
     *
     * @var Phone
     */
    private $phone;

    /**
     * `mobilePhone` -- Mobile phone number. Required (if available) unless market or regional mandate restricts sending
     * this information.
     *
     * @var Phone
     */
    private $mobilePhone;

    /**
     * `email` -- Email address. Required unless market or regional mandate restricts sending this information.
     *
     * @var string
     */
    private $email;

    /**
     * @return Consumer
     */
    public function getConsumer()
    {
        return $this->consumer;
    }

    /**
     * @param Consumer $consumer
     * @return CustomerInfo
     */
    public function setConsumer($consumer)
    {
        $this->consumer = $consumer;
        return $this;
    }

    /**
     * @return Business
     */
    public function getBusiness()
    {
        return $this->business;
    }

    /**
     * @param Business $business
     * @return CustomerInfo
     */
    public function setBusiness($business)
    {
        $this->business = $business;
        return $this;
    }

    /**
     * @return Phone
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param Phone $phone
     * @return CustomerInfo
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return Phone
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }

    /**
     * @param Phone $mobilePhone
     * @return CustomerInfo
     */
    public function setMobilePhone($mobilePhone)
    {
        $this->mobilePhone = $mobilePhone;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return CustomerInfo
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'consumer' => $this->consumer,
            'business' => $this->business,
            'phone' => $this->phone,
            'mobilePhone' => $this->mobilePhone,
            'email' => $this->email,
        ]);
    }
}
