<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo;

use JsonSerializable;

/**
 * Class Phone
 * @package LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CustomerInfo
 */
class Phone implements JsonSerializable
{
    /**
     * `countryCode` -- Country code according to ITU-T E.164. Numbers only. No leading zeros.
     *
     * @var string
     */
    private $countryCode;

    /**
     * `subscriberNumber` -- National number according to ITU-T E.164 including national destination code. Numbers only.
     * No leading zeros.
     *
     * @var string
     */
    private $subscriberNumber;

    /**
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }

    /**
     * @param string $countryCode
     * @return Phone
     */
    public function setCountryCode($countryCode)
    {
        $this->countryCode = $countryCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubscriberNumber()
    {
        return $this->subscriberNumber;
    }

    /**
     * @param string $subscriberNumber
     * @return Phone
     */
    public function setSubscriberNumber($subscriberNumber)
    {
        $this->subscriberNumber = $subscriberNumber;
        return $this;
    }

    /**
     * @return array|mixed
     */
    public function jsonSerialize()
    {
        return array_filter([
            'countryCode' => $this->countryCode,
            'subscriberNumber' => $this->subscriberNumber,
        ]);
    }
}
