<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\GICC;

use LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\RequestModel as RequestModelBase;

/**
 * Class RequestModel
 *
 * **WARNING**: The model is specific for _GICC_ acquirers!
 *
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\GICC
 */
class RequestModel extends RequestModelBase
{
    /**
     * `ChDesc` -- Text printed on the customer's credit card bill alongside the payee.
     *
     * @var string
     */
    private $cardHolderDescription;

    /**
     * @return string
     */
    public function getCardHolderDescription()
    {
        return $this->cardHolderDescription;
    }

    /**
     * @param $cardHolderDescription
     * @return RequestModel
     */
    public function setCardHolderDescription($cardHolderDescription)
    {
        $this->cardHolderDescription = $cardHolderDescription;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();

        $parameterData['ChDesc'] = $this->cardHolderDescription;

        return $parameterData;
    }
}
