<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\Address;

use JsonSerializable;

/**
 * Class AddressLine
 * @package LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo
 */
class AddressLine implements JsonSerializable
{
    /**
     * `street` -- Street name.
     *
     * @var string
     */
    private $street;

    /**
     * `streetNumber` -- Street or house number.
     *
     * @var string
     */
    private $streetNumber;

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return AddressLine
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }

    /**
     * @param string $streetNumber
     * @return AddressLine
     */
    public function setStreetNumber($streetNumber)
    {
        $this->streetNumber = $streetNumber;
        return $this;
    }

    public function jsonSerialize()
    {
        return array_filter([
            'street' => $this->street,
            'streetNumber' => $this->streetNumber,
        ]);
    }
}
