<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

// Initialize.
require_once __DIR__ . '/../../bootstrap.php';

use LifeStyle\ComputopPaygateAdapter\Example\Credential;
use LifeStyle\ComputopPaygateAdapter\Model;
use LifeStyle\ComputopPaygateAdapter\PaygateService;
use LifeStyle\ComputopPaygateAdapter\Paytype;

$paygateService = new PaygateService();
$paytypeHandlerList = [
    new Paytype\ServerToServer\CreditCardHandler(),
    new Paytype\ServerToServer\DirectDebitHandler(),
];

foreach ($paytypeHandlerList as $paytypeHandler) {
    $paygateService->addPaytypeHandler($paytypeHandler);
}

// Time of execution.
$time = time();
// Price in currency.
$price = 20.50;
// Currency of the price.
$priceCurrency = 'EUR';

$requestModel = (new Model\ServerToServer\CreditCard\GICC\RequestModel())
    ->setMerchantId(Credential::MERCHANT)
    ->setTransactionId("t{$time}")
    ->setAmount(100 * $price)
    ->setCurrency($priceCurrency)
    ->setRequestId("r{$time}")
    ->setCreditCardNumber('4000012892688323')
    ->setCreditCardValidationCode('012')
    ->setCreditCardExpiry('202012')
    ->setCreditCardBrand('VISA')
    ->setCapture('AUTO') // Optional
    ->setOrderDescription('test:0000')
    ->setReferenceNumber('0123343456103')
    ->setAddressCountryCode('DE')
//    ->setRetailFlag('E') // Optional
    ->setCardHolderDescription('Hello there') // Optional
//    ->setAccountVerification(false) // Optional
    ->setCardHolderCountryCode('DE') // Optional
    ->setCardHolderName('John Doe') // Optional
    ->setCardHolderCity('Aschaffenburg') // Optional
;

// Response, the data that has to be sent to CompuTop.
$responseModel = $paygateService->create(Paytype\ServerToServer\CreditCardHandler::PAYTYPE_NAME, $requestModel);

// Print the target and post body.
echo $responseModel->getTarget(), ' with ', print_r($responseModel->getParameterData(), true), PHP_EOL;

/**
 * Output:
 * > https://www.computop-paygate.com/direct.aspx with Array
 * (
 *   [MerchantID] => vtours_test
 *   [Len] => 380
 *   [Data] => d83d7c6d7394e7725328c630a2db4ab19e7cc5b48b8a84a3ba59e2b64bd5c9d98e75dc2511aa265b7e9fa1c3305a2f08309d2975dbc97fec7d5a4d85a1f5298d3d50ccd455e397d154f6ade553e8ed544051e8500e9e1b1af54aa72737fb5ae65ca33b8a48d2f7925417fd5bfb976398f440fccdcc767ebf80be930bfc33369dc4904754b40026eb96704875441dad9b1a27a6dd8dcd66632f75b0aa6ec184986883fbd9bb870bcc131c0c1aafa5e8d2f2f7df26bd319904a3a55f974b841a9147afd558064088fe64233684a1887f46a38be187afec60b8731ca0d28259f33f070abd621a1aadc1dbd2999003b9d710c756707bf19e0ff953f88b3a23a38bc588323edc8f016a8be979c6760ad4a5384eda20cdc5bb0845d973120801f2a5b6cafdd8a466d97d526e69f9ea7775dd15dad8b6050d0928dfabd7f1ad77004c832e4bc37028775a010a93187cb67983050df3c76931f525ea757efbec4c30e8509ee0c883e78885787d15c0a62a3bec09200a12328d2e0ba2571aa0d1caf6caff
 * )
 */
