<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ServerToServer\DirectDebit\Capture;

use LifeStyle\ComputopPaygateAdapter\Model\ServerToServer\DirectDebit\RequestModel as RequestModelBase;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\ServerToServer\DirectDebit\Capture
 */
class RequestModel extends RequestModelBase
{
    /**
     * `PayID` -- The ID assigned by the paygate for the payment to be captured.
     *
     * @var string
     */
    private $paymentId;

    /**
     * @return string
     */
    public function getPaymentId()
    {
        return $this->paymentId;
    }

    /**
     * @param string $paymentId
     * @return RequestModel
     */
    public function setPaymentId($paymentId)
    {
        $this->paymentId = $paymentId;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();

        $parameterData['PayID'] = $this->paymentId;

        return $parameterData;
    }
}
