<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Paytype;

use LifeStyle\ComputopPaygateAdapter\Utility\ResponseFactory;

/**
 * Class PaytypeHandlerAbstract
 * @package LifeStyle\ComputopPaygateAdapter\Paytype
 */
abstract class PaytypeHandlerAbstract implements PaytypeHandlerInterface
{
    /**
     * @var string|null The paytype name.
     */
    const PAYTYPE_NAME = null;

    /**
     * @var string|null The paytype target base.
     */
    protected static $TARGET = null;

    /**
     * Set the paytype target base.
     *
     * @param string $targetBase
     */
    public static function setTarget($targetBase)
    {
        static::$TARGET = $targetBase;
    }

    /**
     * @inheritDoc
     */
    public function canHandle($paytypeName)
    {
        return static::PAYTYPE_NAME === $paytypeName;
    }

    /**
     * @inheritDoc
     */
    public function handle($requestModel)
    {
        $requestModel->setTarget(static::$TARGET);
        return ResponseFactory::createResponseFromRequestModel($requestModel);
    }
}
