<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

// Initialize.
require_once __DIR__ . '/../../bootstrap.php';

use LifeStyle\ComputopPaygateAdapter\Example\Credential;
use LifeStyle\ComputopPaygateAdapter\Model;
use LifeStyle\ComputopPaygateAdapter\PaygateService;
use LifeStyle\ComputopPaygateAdapter\Paytype;

$paygateService = new PaygateService();
$paytypeHandlerList = [
    new Paytype\ServerToServer\CreditCardHandler(),
    new Paytype\ServerToServer\DirectDebitHandler(),
];

foreach ($paytypeHandlerList as $paytypeHandler) {
    $paygateService->addPaytypeHandler($paytypeHandler);
}

// Time of execution.
$time = time();
// Price in currency.
$price = 20.50;
// Currency of the price.
$priceCurrency = 'EUR';

$requestModel = (new Model\ServerToServer\CreditCard\GICC\RequestModel())
    ->setMerchantId(Credential::MERCHANT)
    ->setTransactionId("t{$time}")
//    ->setAmount(100 * $price) // Optional if $accountVerification is set.
    ->setCurrency($priceCurrency)
    ->setRequestId("r{$time}")
    ->setCreditCardNumber('4000016435940133')
    ->setCreditCardValidationCode('123')
    ->setCreditCardExpiry('202012')
    ->setCreditCardBrand('VISA')
//    ->setCapture('AUTO') // Optional
    ->setOrderDescription('test:0000')
    ->setReferenceNumber('0123343456112')
    ->setAddressCountryCode('DE')
    ->setRetailFlag('E') // Optional
//    ->setCardHolderDescription('i only do verify') // Optional
    ->setAccountVerification(true)
//    ->setCardHolderCountryCode('DE') // Optional
//    ->setCardHolderName('John Doe') // Optional
//    ->setCardHolderCity('Aschaffenburg') // Optional
;

// Response, the data that has to be sent to CompuTop.
$responseModel = $paygateService->create(Paytype\ServerToServer\CreditCardHandler::PAYTYPE_NAME, $requestModel);

// Print the target and post body.
echo $responseModel->getTarget(), ' with ', print_r($responseModel->getParameterData(), true), PHP_EOL;

/**
 * Output:
 * > https://www.computop-paygate.com/direct.aspx with Array
 * (
 *   [MerchantID] => vtours_test
 *   [Len] => .
 *   [Data] => .
 * )
 */
