<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\Address;

use JsonSerializable;

/**
 * Class Country
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\Extra\ThreeDSecureTwo
 */
class Country implements JsonSerializable
{
    /**
     * `countryName` -- Name of the country.
     *
     * @var string
     */
    private $countryName;

    /**
     * `countryA2` -- ISO-3166 alpha-2 code.
     *
     * @var string
     */
    private $countryA2;

    /**
     * `countryA3` -- ISO-3166 alpha-3 code.
     *
     * @var string
     */
    private $countryA3;

    /**
     * `countryNumber` -- ISO-3166 numeric code.
     *
     * @var string
     */
    private $countryNumber;

    /**
     * @return string
     */
    public function getCountryName()
    {
        return $this->countryName;
    }

    /**
     * @param string $countryName
     * @return Country
     */
    public function setCountryName($countryName)
    {
        $this->countryName = $countryName;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountryA2()
    {
        return $this->countryA2;
    }

    /**
     * @param string $countryA2
     * @return Country
     */
    public function setCountryA2($countryA2)
    {
        $this->countryA2 = $countryA2;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountryA3()
    {
        return $this->countryA3;
    }

    /**
     * @param string $countryA3
     * @return Country
     */
    public function setCountryA3($countryA3)
    {
        $this->countryA3 = $countryA3;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountryNumber()
    {
        return $this->countryNumber;
    }

    /**
     * @param string $countryNumber
     * @return Country
     */
    public function setCountryNumber($countryNumber)
    {
        $this->countryNumber = $countryNumber;
        return $this;
    }

    /**
     * @return array|mixed
     * @internal
     */
    public function jsonSerialize()
    {
        return array_filter([
            'countryName' => $this->countryName,
            'countryA2' => $this->countryA2,
            'countryA3' => $this->countryA3,
            'countryNumber' => $this->countryNumber,
        ]);
    }
}
