<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Utility;

/**
 * Class Cookie
 * @package LifeStyle\ComputopPaygateAdapter\Utility
 */
final class Cookie
{
    /**
     * Cookie constructor.
     */
    private function __construct()
    {
    }

    /**
     * Fix the cookie `Path` attribute, if it is not supported in the current PHP version (>=7.3.0).
     *
     * @param string $path
     * @param string $sameSite
     * @return string
     */
    public static function fixSameSitePath($path, $sameSite)
    {
        if (!self::hasSameSiteSupport()) {
            $path = "{$path}; SameSite={$sameSite}";
        }

        return $path;
    }

    /**
     * Check if the `SameSite` cookie attribute is supported in the current PHP version (>=7.3.0).
     *
     * @return bool
     */
    public static function hasSameSiteSupport()
    {
        return !(PHP_VERSION_ID < 70300);
    }
}
