<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo;

use JsonSerializable;
use LifeStyle\ComputopPaygateAdapter\Model\ThreeDSecureTwo\CredentialOnFile\Type;

/**
 * Class CredentialOnFile
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\CreditCard\Extra\ThreeDSecureTwo
 */
class CredentialOnFile implements JsonSerializable
{
    /**
     * `type` -- Type of credential on file payment.
     *
     * @var Type
     */
    private $type;

    /**
     * `initialPayment` -- Indicates whether a card on file transaction is the first one in a series of transactions
     * (establishment) or a subsequent transaction.
     *
     * @var bool
     */
    private $initialPayment;

    /**
     * @return Type
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param Type $type
     * @return CredentialOnFile
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return bool
     */
    public function isInitialPayment()
    {
        return $this->initialPayment;
    }

    /**
     * @param bool $initialPayment
     * @return CredentialOnFile
     */
    public function setInitialPayment($initialPayment)
    {
        $this->initialPayment = $initialPayment;
        return $this;
    }

    /**
     * @return array|mixed
     * @internal
     */
    public function jsonSerialize()
    {
        return array_filter([
            'type' => $this->type,
            'initialPayment' => $this->initialPayment,
        ], function ($value) {
            // Only null values should be filtered out, keeping the false values.
            return $value !== null;
        });
    }
}
