<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\DirectDebit;

use LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\RequestModel as RequestModelBase;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\PaymentPage\DirectDebit
 */
class RequestModel extends RequestModelBase
{
    /**
     * `OrderDesc` -- Description of purchased goods, unit prices etc. The first 27 characters appear on the
     * customer-account statement. You can view the full data in Computop Analytics.
     *
     * To test error behaviour, set this to `test:0000`. The part beyond the colon can be substituted with any of the
     * codes listed under "Detailed error code".
     *
     * @var string
     */
    private $orderDescription;

    /**
     * `MandateID` -- For SEPA: SEPA mandate number (compulsory in the case of SEPA).
     *
     * Should be unique, is not case-sensitive.
     *
     * Permissible characters: numbers 0-9, upper case letters A-Z, lower case letters a-z, apostrophe, colon, question
     * mark, comma, full stop, plus sign, minus sign, forward slash, left and right bracket.
     *
     * @var string
     */
    private $mandateId;

    /**
     * `DtOfSgntr` -- For SEPA: Date of issuing the mandate in the format `DD.MM.YYYY` (obligatory when transferring the
     * `MandateID`).
     *
     * @var string
     */
    private $dateOfSignature;

    /**
     * `MdtSeqType` -- For SEPA: Indicates whether the direct debit is a first, recurring, one-off or final direct
     * debit. Permissible values:
     *
     * - FRST
     * - RCUR
     * - OOFF
     * - FNAL
     *
     * Standard: OOFF (single direct debit).
     *
     * @var string
     */
    private $mandateSequenceType;

    /**
     * @return string
     */
    public function getOrderDescription()
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestModel
     */
    public function setOrderDescription($orderDescription)
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateId()
    {
        return $this->mandateId;
    }

    /**
     * @param string $mandateId
     * @return RequestModel
     */
    public function setMandateId($mandateId)
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateOfSignature()
    {
        return $this->dateOfSignature;
    }

    /**
     * @param string $dateOfSignature
     * @return RequestModel
     */
    public function setDateOfSignature($dateOfSignature)
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateSequenceType()
    {
        return $this->mandateSequenceType;
    }

    /**
     * @param string $mandateSequenceType
     * @return RequestModel
     */
    public function setMandateSequenceType($mandateSequenceType)
    {
        $this->mandateSequenceType = $mandateSequenceType;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();

        $parameterData['OrderDesc'] = $this->orderDescription;

        if (isset($this->mandateId)) {
            $parameterData['MandateID'] = $this->mandateId;
            $parameterData['DtOfSgntr'] = $this->dateOfSignature;
            $parameterData['MdtSeqType'] = $this->mandateSequenceType;
        }

        return $parameterData;
    }
}
