<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model;

use LifeStyle\ComputopPaygateAdapter\Utility\ResponseFactory;

/**
 * Class ResponseModel
 * @package LifeStyle\ComputopPaygateAdapter\Model
 */
final class ResponseModel implements ParameterProviderInterface
{
    /**
     * The paytype request target base. To create a valid `GET` target, use {@see ResponseFactory::createTarget()}.
     *
     * @var string
     */
    private $target;

    /**
     * The merchant id. The same value as {@see RequestModel::$merchantId}.
     *
     * @var string
     */
    private $merchantId;

    /**
     * The length of the unencrypted query string.
     *
     * @var integer
     */
    private $length;

    /**
     * The encrypted query string.
     *
     * @var string
     */
    private $data;

    /**
     * @var array
     */
    private $dataPayload;

    /**
     * ResponseModel constructor.
     */
    public function __construct()
    {
        $this->dataPayload = [];
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param string $target
     * @return ResponseModel
     */
    public function setTarget($target)
    {
        $this->target = $target;
        return $this;
    }

    /**
     * @return string
     */
    public function getMerchantId()
    {
        return $this->merchantId;
    }

    /**
     * @param string $merchantId
     * @return ResponseModel
     */
    public function setMerchantId($merchantId)
    {
        $this->merchantId = $merchantId;
        return $this;
    }

    /**
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * @param int $length
     * @return ResponseModel
     */
    public function setLength($length)
    {
        $this->length = $length;
        return $this;
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param string $data
     * @return ResponseModel
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return array
     */
    public function getDataPayload()
    {
        return $this->dataPayload;
    }

    /**
     * @param array $dataPayload
     * @return ResponseModel
     */
    public function setDataPayload($dataPayload)
    {
        $this->dataPayload = $dataPayload;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        return array_replace($this->dataPayload, [
            'MerchantID'    => $this->merchantId,
            'Len'           => $this->length,
            'Data'          => $this->data,
        ]);
    }
}
