<?php

require './vendor/autoload.php';

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use LifeStyle\ComputopPaygateAdapter\Model;
use LifeStyle\ComputopPaygateAdapter\Model\RequestModel;
use LifeStyle\ComputopPaygateAdapter\PaygateService;
use LifeStyle\ComputopPaygateAdapter\Paytype\CreditCardHandler;
use LifeStyle\ComputopPaygateAdapter\Paytype\DirectDebitHandler;
use LifeStyle\ComputopPaygateAdapter\Utility\ResponseFactory;

$paygateService = new PaygateService();
$paytapeHandlerList = [
    new CreditCardHandler(),
    new DirectDebitHandler(),
];

ResponseFactory::setKey('Rp5?d)K2Hr9_q]Y6');
ResponseFactory::setKeyHash('9q)NH4y_z(2D5kP=?J8n3[fZ*pR76S!c');

foreach ($paytapeHandlerList as $paytypeHandler) {
    $paygateService->addPaytypeHandler($paytypeHandler);
}

/**
 * @return RequestModel
 */
function getRequestModel()
{
    $requestModel = new Model\CreditCard\RequestModel();
    // Pro-Tip: Look at the field documentation inside the model class.
    $requestModel
        ->setAmount(2000)
        ->setAmount3D(2000)
        ->setCurrency('EUR')
        ->setMerchantId('vtours_test')
        ->setTransactionId(124726274343);

    // Note: The redirect and notification target has to be "https"!
    //->setRedirectOnSuccess('https://localhost/success.php')
    //->setRedirectOnFailure('https://localhost/error.php');

    return $requestModel;
}

$responseModel = $paygateService->create(CreditCardHandler::PAYTYPE_NAME, getRequestModel());
$target = ResponseFactory::createTarget($responseModel);

echo 'target';
echo PHP_EOL;
echo "<a href={$target} target='_blank'>{$target}</a>";
echo PHP_EOL;

return true;
