<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\DirectDebit;

use LifeStyle\ComputopPaygateAdapter\Model\RequestModel as BaseRequestModel;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\DirectDebit
 */
class RequestModel extends BaseRequestModel
{
    /**
     * `OrderDesc` -- Description of purchased goods, unit prices etc. The first 27 characters appear on the
     * customer-account statement. You can view the full data in Computop Analytics.
     *
     * @var string
     */
    private $orderDescription;

    /**
     * `MandateID` -- SEPA-Mandate number required
     *
     *
     * @var string
     */
    private $mandateId;

    /**
     * @var string -- Date of signature ( when manda
     */
    private $dtOfSgntr;

    /**
     * @return string
     */
    public function getOrderDescription()
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestModel
     */
    public function setOrderDescription($orderDescription)
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateId()
    {
        return $this->mandateId;
    }

    /**
     * @param string $MandateId
     * @return RequestModel
     */
    public function setMandateId($mandateId)
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return string
     */
    public function getDtOfSgntr()
    {
        return $this->dtOfSgntr;
    }

    /**
     * @param string $dtOfSgntr
     * @return RequestModel
     */
    public function setDtOfSgntr($dtOfSgntr)
    {
        $this->dtOfSgntr = $dtOfSgntr;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();
        $parameterData['OrderDesc'] = $this->orderDescription;
        if (isset($this->mandateId)) {
            $parameterData['DtOfSgntr'] = $this->dtOfSgntr;
            $parameterData['MandateID'] = $this->mandateId;
        }
        return $parameterData;
    }
}
