<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require './vendor/autoload.php';

use LifeStyle\ComputopPaygateAdapter\Utility\Security;

Security::setKey('Rp5?d)K2Hr9_q]Y6');
Security::setKeyHash('9q)NH4y_z(2D5kP=?J8n3[fZ*pR76S!c');

$_POST['Len'] = 302;
$_POST['Data'] = '69E3AC5316CB2A45ABA324C2B3BF3E793F0C657195F694526DEA226BA0B1C4CA8288DB67FCA692604585D85179417AAD51EA8B16C277F82D5B77B9FD71C7BBAA70FAAEDFD40BA55E82EA8F4C64DD2C72CA928DF33446D26D0DBD6B822630AA20BC7681EF240E09F73AFEEFECB934504F402E97DBCF49E7354867EAFE152F7E6DEC805C4FD52EFBB055EBE2A74DD2579E456D90498ECA561967C9544EFC016AD7FA4EBA85A6F3FF45CC2DBC307B9F8C9B1A03B31174408EED6A37961FAA5C5FB7875AAED5228C146E098DEB6184A0586BEE6B516C85F5652EC9D634E3147FEE4538C66C66A657B9DE97C857DCD8271B794EA57378174A2D6CE3CDDC404E103E5DB90BAA96796AA9E1B9095A36A2C379E58DB0FDD4899A8562169F43ED1DF91B1CAA851C58CC7C58A2C00E7528D8EA7763';

/**
 * Class Notification
 */
final class Notification
{
    /**
     * @var integer
     */
    private $length;

    /**
     * @var array
     */
    private $data;

    /**
     * Create a new notification instance from post-like array.
     *
     * @param array $parameterData
     * @return Notification
     */
    public static function createFromParameterData($parameterData)
    {
        $parameterData = array_replace([
            'Len' => 0,
            'Data' => '',
        ], $parameterData);

        $length = $parameterData['Len'];
        $data = $parameterData['Data'];

        return new self($length, $data);
    }

    /**
     * Notification constructor.
     * @param integer $length
     * @param string $data
     */
    private function __construct($length, $data)
    {
        $this->length = $length;
        $this->data = $data;
    }

    /**
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * @param int $length
     * @return Notification
     */
    public function setLength($length)
    {
        $this->length = $length;
        return $this;
    }

    /**
     * @return string
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param string $data
     * @return Notification
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @return array
     */
    public function getContent()
    {
        static $content;

        if (!$content) {
            $result = Security::decrypt($this->data);
            $result = substr($result, 0, $this->length);

            parse_str($result, $content);
        }

        return $content;
    }
}

$notification = Notification::createFromParameterData($_POST);
$notificationContent = $notification->getContent();

echo '<pre>';
var_dump($notificationContent);
echo '</pre>';

return true;
