<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\DirectDebit;

use LifeStyle\ComputopPaygateAdapter\Model\RequestModel as BaseRequestModel;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\DirectDebit
 */
class RequestModel extends BaseRequestModel
{
    /**
     * `OrderDesc` -- Description of purchased goods, unit prices etc. The first 27 characters appear on the
     * customer-account statement. You can view the full data in Computop Analytics.
     *
     * @var string
     */
    private $orderDescription;

    /**
     * `MandateID` -- For SEPA: SEPA mandate number (compulsory in the case of SEPA).
     *
     * Should be unique, is not case-sensitive.
     *
     * Permissible characters: numbers 0-9, upper case letters A-Z, lower case letters a-z, apostrophe, colon, question
     * mark, comma, full stop, plus sign, minus sign, forward slash, left and right bracket.
     *
     * @var string
     */
    private $mandateId;

    /**
     * `DtOfSgntr` -- For SEPA: Date of issuing the mandate in the format `DD.MM.YYYY` (obligatory when transferring the
     * `MandateID`).
     *
     * @var string
     */
    private $dateOfSignature;

    /**
     * @return string
     */
    public function getOrderDescription()
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestModel
     */
    public function setOrderDescription($orderDescription)
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @return string
     */
    public function getMandateId()
    {
        return $this->mandateId;
    }

    /**
     * @param string $mandateId
     * @return RequestModel
     */
    public function setMandateId($mandateId)
    {
        $this->mandateId = $mandateId;
        return $this;
    }

    /**
     * @return string
     */
    public function getDateOfSignature()
    {
        return $this->dateOfSignature;
    }

    /**
     * @param string $dateOfSignature
     * @return RequestModel
     */
    public function setDateOfSignature($dateOfSignature)
    {
        $this->dateOfSignature = $dateOfSignature;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();
        $parameterData['OrderDesc'] = $this->orderDescription;

        if (isset($this->mandateId)) {
            $parameterData['MandateID'] = $this->mandateId;
            $parameterData['DtOfSgntr'] = $this->dateOfSignature;
        }

        return $parameterData;
    }
}
