<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Paytype;

use LifeStyle\ComputopPaygateAdapter\Model\RequestModel;
use LifeStyle\ComputopPaygateAdapter\Model\ResponseModel;

/**
 * Interface PaytypeHandlerInterface
 * @package LifeStyle\ComputopPaygateAdapter\Paytype
 */
interface PaytypeHandlerInterface
{
    /**
     * @param string $paytypeName
     * @return bool
     */
    public function canHandle($paytypeName);

    /**
     * @param RequestModel $requestModel
     * @return ResponseModel
     */
    public function handle($requestModel);
}
