<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Utility;

/**
 * Class Security
 * @package LifeStyle\ComputopPaygateAdapter\Utility
 */
final class Security
{
    /**
     * @var string|null
     */
    private static $KEY = null;

    /**
     * @var string|null
     */
    private static $KEY_HASH = null;

    /**
     * @param string|null $key
     */
    public static function setKey($key)
    {
        self::$KEY = $key;
    }

    /**
     * @param string|null $keyHash
     */
    public static function setKeyHash($keyHash)
    {
        self::$KEY_HASH = $keyHash;
    }

    /**
     * Security constructor.
     */
    private function __construct()
    {
    }

    /**
     * See the {@see https://www.php.net/manual/en/function.openssl-encrypt.php#121545 source}.
     *
     * @param string $input
     * @return string
     */
    public static function encrypt($input)
    {
        // Fill the input with space character.
        if (($length = strlen($input) % 8) > 0) {
            $input = $input . str_repeat(' ', 8 - $length);
        }

        $output = '';
        if (function_exists('mcrypt_encrypt')) {
            $output = mcrypt_encrypt(MCRYPT_BLOWFISH, self::$KEY, $input, MCRYPT_MODE_ECB, null);
        } else {
            $output = openssl_encrypt($input, 'BF-ECB', self::$KEY, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING);
            if (!is_string($output)) {
                $output = '';
            }
        }

        return bin2hex($output);
    }

    /**
     * @param string $input
     * @return string
     */
    public static function decrypt($input)
    {
        $input = hex2bin($input);

        $output = '';
        if (function_exists('mcrypt_decrypt')) {
            $output = mcrypt_decrypt(MCRYPT_BLOWFISH, self::$KEY, $input, MCRYPT_MODE_ECB, null);
        } else {
            $output = openssl_decrypt($input, 'BF-ECB', self::$KEY, OPENSSL_RAW_DATA | OPENSSL_NO_PADDING);
            if (!is_string($output)) {
                $output = '';
            }
        }

        // Remove redundant space character.
        return rtrim($output, ' ');
    }

    /**
     * @param string $input
     * @return string
     */
    public static function hash($input)
    {
        $output = hash_hmac('sha256', $input, self::$KEY_HASH, true);
        return bin2hex($output);
    }
}
