<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\CreditCard;

use LifeStyle\ComputopPaygateAdapter\Model\RequestModel as BaseRequestModel;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\CreditCard
 */
class RequestModel extends BaseRequestModel
{
    /**
     * `Amount3D` -- Only for 3DSecure: Amount for authentication with Verified, SecureCode and SafeKey if Amount
     * deviates. Amount in the smallest currency unit (e.g. EUR Cent).
     *
     * @var int
     */
    private $amount3d;

    /**
     * @return int
     */
    public function getAmount3D()
    {
        return $this->amount3d;
    }

    /**
     * @param int $amount3d
     * @return RequestModel
     */
    public function setAmount3D($amount3d)
    {
        $this->amount3d = $amount3d;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();
        $parameterData['amount3D'] = $this->amount3d;
        return $parameterData;
    }
}
