<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ComputopPaygateAdapter\Model\KlarnaSofort;

use LifeStyle\ComputopPaygateAdapter\Model\RequestModel as BaseRequestModel;

/**
 * Class RequestModel
 * @package LifeStyle\ComputopPaygateAdapter\Model\KlarnaSofort
 */
class RequestModel extends BaseRequestModel
{
    /**
     * `RefNr` -- Unique reference number.
     *
     * @var string
     */
    private $referenceNumber;

    /**
     * `OrderDesc` -- Reason for payment on customer-account statement. **Notice**: Only the first 27 characters appear
     * on the customer-account statement. You can view the full data in Computop Analytics.
     *
     * @var string
     */
    private $orderDescription;

    /**
     * `AddrCountryCode` -- Two characters country code according to ISO 3166. Presently DE, AT, BE, NL, ES, CH, PL, IT
     * permitted.
     *
     * @var string
     */
    private $countryCode;

    /**
     * @return string
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }

    /**
     * @param string $countryCode
     * @return RequestModel
     */
    public function setCountryCode($countryCode)
    {
        $this->countryCode = $countryCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }

    /**
     * @param string $referenceNumber
     * @return RequestModel
     */
    public function setReferenceNumber($referenceNumber)
    {
        $this->referenceNumber = $referenceNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDescription()
    {
        return $this->orderDescription;
    }

    /**
     * @param string $orderDescription
     * @return RequestModel
     */
    public function setOrderDescription($orderDescription)
    {
        $this->orderDescription = $orderDescription;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getParameterData()
    {
        $parameterData = parent::getParameterData();
        $parameterData['RefNr'] = $this->referenceNumber;
        $parameterData['OrderDesc'] = $this->orderDescription;
        $parameterData['AddrCountryCode'] = strtoupper($this->countryCode);
        return $parameterData;
    }
}
