<?php

/**
 * Class DataCollectorItem
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\DataCollector;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class DataCollectorItem
 * @package Lifestyle\DataCollector
 */
class DataCollectorItem implements DataCollectorItemInterface
{
    /**
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $key;

    /**
     * @Serializer\Accessor(getter="getValueAsString", setter="setValueFromString")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $locale;

    /**
     * CollectorItem constructor.
     * @param string $key
     * @param mixed $value
     * @param string $locale
     */
    public function __construct($key, $value, $locale = null)
    {
        $this->key = $key;
        $this->value = $value;
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param mixed $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @internal
     * @param string $value
     */
    public function setValueFromString($value)
    {
        $this->value = unserialize($value);
    }

    /**
     * @internal
     * @return string
     */
    public function getValueAsString()
    {
        return serialize($this->value);
    }

    /**
     * @param string $locale
     */
    public function setLocale($locale)
    {
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @return bool
     */
    public function hasLocale()
    {
        return null !== $this->locale;
    }
}
