<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\DataCollector;

use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\DataCollector
 */
class FactoryTest extends TestCase
{
    public function testDataCollectorItem()
    {
        $factory = new Factory();

        $key = 'any-key';
        $value = mt_rand();
        $locale = 'tlh';

        $dataCollectorItem = $factory->dataCollectorItem($key, $value, $locale);

        $this->assertInstanceOf(DataCollectorItemInterface::class, $dataCollectorItem);
        $this->assertEquals($key, $dataCollectorItem->getKey());
        $this->assertEquals($value, $dataCollectorItem->getValue());
        $this->assertEquals($locale, $dataCollectorItem->getLocale());
    }

    public function testDataCollector()
    {
        $factory = new Factory();

        $dataCollector = $factory->dataCollector();
        $this->assertInstanceOf(DataCollectorInterface::class, $dataCollector);
    }
}
