<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Generator\Type;

use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapGeneratorOutput;
use Psr\Log\LoggerInterface;

/**
 * Class DebugGeneratorType
 * @package GenericSitemap\Generator\Type
 */
class DebugGeneratorType implements SitemapGeneratorTypeInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * DebugGeneratorType constructor.
     * @param LoggerInterface $logger
     */
    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @param SitemapGeneratorInput $sitemapGeneratorInput
     * @param SitemapGeneratorOutput $sitemapGeneratorOutput
     * @return void
     */
    public function generate($sitemapGeneratorInput, $sitemapGeneratorOutput)
    {
        $this->logger->debug('Output:');
        foreach ($sitemapGeneratorOutput->getSitemapOutputList() as $index => $sitemapOutput) {
            $this->logger->debug($index . ' Type:    ' . $sitemapOutput->getType());
            $this->logger->debug($index . ' Name:    ' . $sitemapOutput->getName());
            $this->logger->debug($index . ' Content: ' . $sitemapOutput->getContent());
        }
    }
}
