<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\Sitemap;

/**
 * Class Priority
 * @package GenericSitemap\Model\Sitemap
 */
class Priority
{
    /**
     * @var float
     */
    const MIN = 0.0;

    /**
     * @var float
     */
    const MAX = 1.0;

    /**
     * @param float $priority
     * @return float
     */
    public static function getPriority($priority)
    {
        return max(self::MIN, min(self::MAX, $priority));
    }
}
