<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\Sitemap;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Sitemap
 * @package GenericSitemap\Model\Sitemap
 *
 * @Serializer\XmlRoot("urlset", namespace="http://www.sitemaps.org/schemas/sitemap/0.9")
 */
class Urlset
{
    /**
     * @var array|Url[]
     *
     * @Serializer\Type("array<GenericSitemap\Model\Sitemap\Url>")
     * @Serializer\XmlList(inline=true, entry="url")
     */
    private $urlset;

    /**
     * Sitemap constructor.
     */
    public function __construct()
    {
        $this->urlset = [];
    }

    /**
     * @param string $loc
     * @param null|string $lastmod
     * @param null|string $changefreq
     * @param null|float $priority
     * @return Urlset
     */
    public function addData($loc, $lastmod = null, $changefreq = null, $priority = null)
    {
        $url = new Url($loc);
        $url->setLastmod($lastmod);
        $url->setChangefreq($changefreq);
        $url->setPriority($priority);
        return $this->addUrl($url);
    }

    /**
     * @param Url $url
     * @return Urlset
     */
    public function addUrl($url)
    {
        $this->urlset[] = $url;
        return $this;
    }

    /**
     * @return array|Url[]
     */
    public function getUrlset()
    {
        return $this->urlset;
    }

    /**
     * @param array|Url[] $urlset
     * @return Urlset
     */
    public function setUrlset($urlset)
    {
        $this->urlset = $urlset;
        return $this;
    }
}
