<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model;

use GenericSitemap\Model\Sitemap\Urlset;

/**
 * Class SitemapInputModel
 * @package GenericSitemap\Model
 */
class SitemapGeneratorInput
{
    /**
     * @var array|SitemapInput[]
     */
    private $sitemapInputList;

    /**
     * SitemapGeneratorInput constructor.
     */
    public function __construct()
    {
        $this->sitemapInputList = [];
    }

    /**
     * @param string $name
     * @param Urlset $sitemap
     * @return SitemapGeneratorInput
     */
    public function addData($name, $sitemap)
    {
        $sitemapInput = new SitemapInput($name);
        $sitemapInput->addUrlset($sitemap);
        return $this->addSitemapInput($sitemapInput);
    }

    /**
     * @param SitemapInput $sitemapInput
     * @return SitemapGeneratorInput
     */
    public function addSitemapInput($sitemapInput)
    {
        $this->sitemapInputList[] = $sitemapInput;
        return $this;
    }

    /**
     * @return array|SitemapInput[]
     */
    public function getSitemapInputList()
    {
        return $this->sitemapInputList;
    }

    /**
     * @param array|SitemapInput[] $sitemapInputList
     * @return SitemapGeneratorInput
     */
    public function setSitemapInputList($sitemapInputList)
    {
        $this->sitemapInputList = $sitemapInputList;
        return $this;
    }
}
