<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Model\SitemapIndex;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SitemapIndex
 * @package GenericSitemap\Model\SitemapIndex
 *
 * @Serializer\XmlRoot("sitemapindex", namespace="http://www.sitemaps.org/schemas/sitemap/0.9")
 */
class SitemapIndex
{
    /**
     * @var array|Sitemap[]
     *
     * @Serializer\Type("array<GenericSitemap\Model\SitemapIndex\Sitemap>")
     * @Serializer\XmlList(inline=true, entry="sitemap")
     */
    private $sitemapindex;

    /**
     * SitemapIndex constructor.
     */
    public function __construct()
    {
        $this->sitemapindex = [];
    }

    /**
     * @param string $loc
     * @param string $lastmod
     * @return SitemapIndex
     */
    public function addData($loc, $lastmod = null)
    {
        $sitemap = new Sitemap($loc);
        $sitemap->setLastmod($lastmod);
        return $this->addSitemap($sitemap);
    }

    /**
     * @param Sitemap $sitemap
     * @return SitemapIndex
     */
    public function addSitemap($sitemap)
    {
        $this->sitemapindex[] = $sitemap;
        return $this;
    }

    /**
     * @return array|Sitemap[]
     */
    public function getSitemapindex()
    {
        return $this->sitemapindex;
    }

    /**
     * @param array|Sitemap[] $sitemapindex
     * @return SitemapIndex
     */
    public function setSitemapindex($sitemapindex)
    {
        $this->sitemapindex = $sitemapindex;
        return $this;
    }
}
