<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Tests\GenericSitemap\Model\Sitemap;

use GenericSitemap\Model\Sitemap\Lastmod;
use PHPUnit\Framework\TestCase;

class LastmodTest extends TestCase
{
    public function test_is_valid_with_valid_lastmod()
    {
        $this->assertTrue(
            Lastmod::isValid(date('Y-m-d'))
        );
    }

    public function test_is_valid_with_invalid_lastmod()
    {
        $this->assertNotTrue(
            Lastmod::isValid(date('d-m-Y'))
        );
    }
}
