<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Generator\Type;

use GenericSitemap\Serializer\SitemapSerializerInterface;

/**
 * Class AbstractGeneratorType
 * @package GenericSitemap\Generator\Type
 */
abstract class AbstractGeneratorType implements SitemapGeneratorTypeInterface
{
    /**
     * @var SitemapSerializerInterface
     */
    protected $serializer;

    /**
     * SitemapGeneratorType constructor.
     * @param SitemapSerializerInterface $serializer
     */
    public function __construct($serializer)
    {
        $this->serializer = $serializer;
    }
}
