<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace GenericSitemap\Generator\Type;

use GenericSitemap\Model\SitemapGeneratorInput;
use GenericSitemap\Model\SitemapGeneratorOutput;

/**
 * Class SitemapGeneratorType
 * @package GenericSitemap\Generator\Type
 */
final class SitemapGeneratorType extends AbstractGeneratorType
{
    /**
     * @var string
     */
    const TYPE = 'Sitemap';

    /**
     * @param SitemapGeneratorInput $sitemapGeneratorInput
     * @param SitemapGeneratorOutput $sitemapGeneratorOutput
     * @return void
     */
    public function generate($sitemapGeneratorInput, $sitemapGeneratorOutput)
    {
        foreach ($sitemapGeneratorInput->getSitemapInputList() as $sitemapInput) {
            foreach ($sitemapInput->getUrlsetList() as $index => $urlset) {
                $name = $sitemapInput->getName() . '-' . $index;
                $content = $this->serializer->serialize($urlset);

                $sitemapGeneratorOutput->addData(self::TYPE, $name, $content);
            }
        }
    }
}
